/* -LICENSE-START-
** Copyright (c) 2011 Blackmagic Design
**
** Permission is hereby granted, free of charge, to any person or organization
** obtaining a copy of the software and accompanying documentation covered by
** this license (the "Software") to use, reproduce, display, distribute,
** execute, and transmit the Software, and to prepare derivative works of the
** Software, and to permit third-parties to whom the Software is furnished to
** do so, all subject to the following:
** 
** The copyright notices in the Software and this entire statement, including
** the above license grant, this restriction and the following disclaimer,
** must be included in all copies of the Software, in whole or in part, and
** all derivative works of the Software, unless such copies or derivative
** works are solely in the form of machine-executable object code generated by
** a source language processor.
** 
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
** SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
** FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
** ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
** DEALINGS IN THE SOFTWARE.
** -LICENSE-END-
*/

#ifndef BMD_STREAMING_PREVIEW_DECODER_MF_H__
#define BMD_STREAMING_PREVIEW_DECODER_MF_H__

#include "DeckLinkAPI_h.h"

#include "PreviewWindow.h"
#include <deque>

class DecoderMF
{
public:
	DecoderMF();
	~DecoderMF();

public:
	// Happens out of our thread context.
	void						SetPreviewWindow(PreviewWindow* previewWindow);
	bool						HandleNALPacket(IBMDStreamingH264NALPacket* nalPacket);

private:
	bool						CreateInputMediaType(IMFMediaType** mediaType);

	bool						DoProcessInputNAL(IBMDStreamingH264NALPacket* nalPacket);
	bool						DoProcessOutput();

	bool						CreateOutputSample();
	bool						HandleStreamChange();

	static DWORD WINAPI			DecoderThreadFunction(void* arg);
	void						DecoderThread();
	
private:
	IMFTransform*				m_h264Decoder;
	IMFSample*					m_outputSample;
	PreviewWindow*				m_previewWindow;
	bool						m_previewConfigured;

	HANDLE						m_decoderThread;
	bool						m_decoderThreadRunning;
	CRITICAL_SECTION			m_criticalSection;
	HANDLE						m_decoderThreadEvent;

	std::deque<IBMDStreamingH264NALPacket*>	m_nalQueue;
};

#endif // BMD_STREAMING_PREVIEW_DECODER_MF_H__

